﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodSchoolsView : BaseAPIMethod
        {

            public MethodSchoolsView(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "schoolsview"; }
            }

            int _schoolId = 0;
            protected override void DoReadRequestParams()
            {
                string _school_id = Component.APIRequestParams["school_id"];
                if (!string.IsNullOrEmpty(_school_id))
                {
                    int.TryParse(_school_id, out _schoolId);
                }
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }

            protected override bool DoValidate()
            {
                if (_schoolId > 0)
                {
                    return true;
                }
                AddErrorMessage("Podano nieprawidłowy identyfikator szkoły.");
                return false;
            }

            protected override GResponseData DoGetGResponseData()
            {
                GSchoolView _GSchoolView = Component.BLELearning.APIMobile.GetGSchoolView(_schoolId);
                if (_GSchoolView != null)
                {
                    StatusCode = StatusCodeType.OK;
                    return new GResponseData_InnerData() { InnerData = _GSchoolView };
                }
                else
                {
                    AddErrorMessage("Nie znaleziono szkoły o podanym identyfikatorze");
                    StatusCode = StatusCodeType.NotFound;
                }
                return null;
            }
        }
    }
}